<?php

class PMS_PaidMemberSubscriptionsDiviExtension extends DiviExtension {

	/**
	 * The gettext domain for the extension's translations.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $gettext_domain = 'pms-paid-member-subscriptions-divi-extension';

	/**
	 * The extension's WP Plugin name.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $name = 'paid-member-subscriptions-divi-extension';

	/**
	 * The extension's version
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $version = '1.0.0';

	/**
	 * PMS_PaidMemberSubscriptionsDiviExtension constructor.
	 *
	 * @param string $name
	 * @param array  $args
	 */
	public function __construct( $name = 'paid-member-subscriptions-divi-extension', $args = array() ) {
		$this->plugin_dir     = plugin_dir_path( __FILE__ );
		$this->plugin_dir_url = plugin_dir_url( $this->plugin_dir );

		$this->_builder_js_data = array(
			'nonces' => array(
				'pms_divi_render_form_nonce' => wp_create_nonce( 'pms_divi_render_form' ),
			)
		);

		parent::__construct( $name, $args );
	}
}

new PMS_PaidMemberSubscriptionsDiviExtension;
