<?php
$bosa_media_marketing_page_one 	= get_theme_mod( 'bosa_media_marketing_blog_services_page_one', '' );
$bosa_media_marketing_page_two 	= get_theme_mod( 'bosa_media_marketing_blog_services_page_two', '' );
$bosa_media_marketing_page_three = get_theme_mod( 'bosa_media_marketing_blog_services_page_three', '' );

$bosa_media_marketing_page_array = array();
$bosa_media_marketing_has_page = false;
if( !empty( $bosa_media_marketing_page_one ) ){
	$bosa_media_marketing_has_page = true;
	$bosa_media_marketing_page_array['page_one'] = array(
		'ID' => $bosa_media_marketing_page_one,
	);
}
if( !empty( $bosa_media_marketing_page_two ) ){
	$bosa_media_marketing_has_page = true;
	$bosa_media_marketing_page_array['page_two'] = array(
		'ID' => $bosa_media_marketing_page_two,
	);
}
if( !empty( $bosa_media_marketing_page_three ) ){
	$bosa_media_marketing_has_page = true;
	$bosa_media_marketing_page_array['page_three'] = array(
		'ID' => $bosa_media_marketing_page_three,
	);
}


if( !get_theme_mod( 'bosa_media_marketing_disable_blog_services_section', true ) && $bosa_media_marketing_has_page ){ ?>
	<section class="section-services-area">
		<div class="content-wrap">
			<div class="row justify-content-center">
				<?php foreach( $bosa_media_marketing_page_array as $bosa_media_marketing_each_page ){ ?>
					<div class="col-md-6 col-lg-4">
						<article class="services-content-wrap text-center">
							<div class="inner-content">
								<figure class="featured-image">
									<?php echo get_the_post_thumbnail( $bosa_media_marketing_each_page[ 'ID' ], 'bosa-media-marketing-420-300' ); ?>
								</figure>
								
								<div class="entry-content">
									<h3 class="entry-title">
										<a href="<?php echo esc_url( get_permalink( $bosa_media_marketing_each_page[ 'ID' ] ) ); ?>">
											<?php echo esc_html( get_the_title( $bosa_media_marketing_each_page[ 'ID' ] ) ); ?>
										</a>
									</h3>
									<div class="entry-text">
										<?php 
										$bosa_media_marketing_excerpt = get_the_excerpt( $bosa_media_marketing_each_page[ 'ID' ] );
										$bosa_media_marketing_result  = wp_trim_words( $bosa_media_marketing_excerpt, 10, '' );
										echo esc_html( $bosa_media_marketing_result );
										?>
									</div>
								</div>
							</div>
							<div class="button-container">
								<a href="<?php echo esc_url( get_permalink( $bosa_media_marketing_each_page[ 'ID' ] ) ); ?>" class="button-text">
									<?php echo esc_html__( 'Continue reading', 'bosa-media-marketing' ); ?>
									<i class="fas fa-arrow-right"></i>
								</a>
							</div>
						</article>
					</div>
				<?php } ?>
			</div>
		</div>
	</section>
<?php } ?>